/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.command;

import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.nativesystem.ExecutionAnalyzer;
import oracle.ops.verification.framework.nativesystem.ExecutionAnalyzerFactory;
import oracle.ops.verification.framework.util.VerificationUtil;

public class RunExeCommand
extends VerificationCommand {
    private static String ARG_RUNEXE = "-runexe";
    private static String ARG_RUNEXENOERR = "-runexenoerr";
    private String m_cmd;

    public RunExeCommand(String nodeName, String cmd) {
        this(nodeName, cmd, false);
    }

    public RunExeCommand(String nodeName, String cmd, boolean discardErrOut) {
        super(nodeName, null, null);
        this.m_cmd = cmd;
        String[] args = new String[]{!discardErrOut ? ARG_RUNEXE : ARG_RUNEXENOERR, cmd};
        super.setArgs(args);
    }

    @Override
    public boolean execute() {
        Trace.out((String)("RunExeCommand::Inside execute() " + Thread.currentThread().getName()));
        boolean bResult = super.execute();
        Result result = this.getResult();
        if (!bResult) {
            String trcTxt = "super.execute() failed for RunExeCommand...";
            Trace.out((String)trcTxt);
            result.addTraceInfo(trcTxt);
            result.addErrorInfo("RunExeCommand failed");
            result.setStatus(2);
            return false;
        }
        String[] resultString = this.getCommandResult().getResultString();
        String reoutput = VerificationUtil.strArr2List(resultString, System.getProperty("line.separator"));
        ExecutionAnalyzer analyzer = ExecutionAnalyzerFactory.getExecutionAnalyzer();
        analyzer.pickRunExeOutput(reoutput, result);
        return true;
    }
}

